@extends('theme.theme')
@section('content')

<div class="mi-card">
    <div class="mi-header info">
        STOCKIST AREAS
    </div>
    <div class="mi-body">
        <table class="table table-bordered mi-table" id="dataTable">
            <thead>
                <th>Stockist Name</th>
                <th>Areas</th>
                <th>Action</th>
            </thead>
            <tbody>
                @foreach($stockists as $stockist)
                    <tr>
                        <td>{{  $stockist?->name }}</td>
                        <td>
                            @foreach($stockist->selected_areas as $area)
                                <span class="gray-badge">{{ $area->area_name . ',' . $area->upazila?->name . ',' . $area->district?->name . ',' . $area->division?->name }}</span>
                            @endforeach
                        </td>
                        <td>
                            <a href="{{ route('admin.mystore.location.assign', ['id' => $stockist->id]) }}"><button class="butn butn-sm warning transparent"><i class="fa fa-edit"></i></button></a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

@endsection
