@extends('theme.theme')
@section('content')

<div class="mi-card">
    <div class="mi-header info">
        ALL MY STORE DELIVERY LOCATIONS
        <div class="mi-right">
            <a href="{{ route('admin.mystore.location.create') }}"><button class="butn success">ADD LOCATION</button></a>
        </div>
    </div>
    <div class="mi-body">
        <table class="table table-bordered mi-table" id="dataTable">
            <thead>
                <th>Id</th>
                <th>Division</th>
                <th>District</th>
                <th>Upazila</th>
                <th>Area Name</th>
                <th>Action</th>
            </thead>
            <tbody>
                @foreach($locations as $location)
                    <tr>
                        <td>{{  $location?->id }}</td>
                        <td>{{  $location?->division->name }}</td>
                        <td>{{  $location?->district->name }}</td>
                        <td>{{  $location?->upazila->name }}</td>
                        <td>{{  $location->area_name }}</td>
                        <td>
                            <a href="{{ route('admin.mystore.location.edit', ['id' => $location->id]) }}">
                                <button class="butn butn-sm warning transparent">
                                    <i class="fa fa-edit"></i>
                                </button>
                            </a>
                            <a onclick="deleteConfirm('{{ route('admin.mystore.location.delete', ['id' => $location->id]) }}','Are you sure to delete')">
                                <button class="butn butn-sm danger transparent">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

@endsection
