@extends('theme.theme')
@section('content')

<div class="row">
    <div class="col-sm-6 m-auto">
        <div class="mi-card">
            <div class="mi-header success">
                ASSIGN AREA
            </div>

            <form action=" {{ route('admin.mystore.location.assign.store', ['id' => $hub->id]) }}" method="POST">
                @csrf
                <div class="mi-body">
                    <div class="form-group">
                        <label for="">Stockist Name</label>
                        <input type="text" value="{{ $hub->name }}" class="form-control" disabled>
                    </div>
                    <div class="form-group">
                        <label for="">Select Areas</label>
                        <select name="area_ids[]" id="areas" multiple>
                            @foreach ($areas as $area)
                                <option value="{{ $area->id }}" {{ in_array($area->id,$hub->area_ids)?'selected':'' }}>{{ $area->area_name . ',' . $area->upazila?->name . ',' . $area->district?->name . ',' . $area->division?->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="mi-footer d-flex justify-content-end">
                    <button type="submit" class="butn success">SAVE</button>
                </div>
            </form>
        </div>
    </div>
</div>
<script>

</script>
@endsection
