@extends('theme.theme')
@section('content')
<div class="mi-card">
    <div class="mi-header info">
        All Product Groups
        <a href="{{ route('group-product.create') }}" class="mi-right">
            <button class="butn warning">Add Group Product</button>
        </a>
    </div>
    <div class="mi-body">
        <table class="mi-table table table-bordered table-striped" id="dataTable">
            <thead>
                <tr>
                    <th>Icon</th>
                    <th>Name (English)</th>
                    <th>Name (Bangla)</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach($groupProducts as $groupProduct)
                <tr>
                    <td><img src="{{ $groupProduct->icon_url }}" alt="" width="50px"></td>
                    <td>{{ $groupProduct->name_en }}</td>
                    <td>{{ $groupProduct->name_bn }}</td>
                    <td>{{ $groupProduct->status_text }}</td>
                    <td>
                        <a href="{{ route('group-product.edit',['id'=>$groupProduct->id]) }}">
                            <button class="butn butn-sm warning transparent"><i class="fa fa-edit"></i></button>
                        </a>
                        <a onclick="return confirm('Are you sure to delete this group')" href="{{ route('group-product.delete',['id'=>$groupProduct->id]) }}">
                            <button class="butn butn-sm danger transparent" title="Delete this account"><i class="fa fa-trash"></i></button>
                        </a>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
