@extends('theme.theme')
@section('content')
<div class="mi-card">
    <div class="mi-header info">ALL DELLERS
        <a href="{{ route('deller.create') }}"><button class="butn success mi-right">ADD NEW DELLER</button></a>
    </div>
    <div class="mi-body">
        <table class="table table-bordered mi-table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>IMAGE</th>
                    <th>NAME</th>
                    <th>SHOP NAME</th>
                    <th>EMAIL</th>
                    <th>PHONE</th>
                    <th>ACTION</th>
                </tr>
            </thead>

            <tbody>
                @foreach($data as $item)
                <tr>
                    <td>{{ $item->id }}</td>
                    <td><img width="50px" src="{{ $item->image_url }}" alt=""></td>
                    <td>{{ $item->first_name. ' ' . $item->last_name }}</td>
                    <td>{{ optional($item->shop)->shop_name_en }}</td>
                    <td>{{ $item->email }}</td>
                    <td>{{ $item->phone }}</td>
                    <th class="mi-action-button">
                        <a href="{{ route('deller.edit',['id'=>$item->id]) }}"><button class="butn butn-sm warning transparent" title="Edit"><i class="fas fa-edit"></i></button></a>
                        <a href=""><button class="butn butn-sm info transparent" title="Orders"><i class="fas fa-box-open"></i></button></a>
                        @if($item->status == ACTIVE)
                        <a href="{{ route('user.change-status',['user_id'=>$item->id,'status'=>0]) }}"><button class="butn butn-sm danger transparent" title="Deactivate account"><i class="fa fa-times"></i></button></a>
                        @else
                        <a href="{{ route('user.change-status',['user_id'=>$item->id,'status'=>1]) }}"><button class="butn butn-sm success transparent" title="Activate Account"><i class="fa fa-check"></i></button></a>
                        @endif
                        <a onclick="return confirm('Are you sure to delete this account')" href="{{ route('user.delete',['user_id'=>$item->id]) }}"><button class="butn butn-sm danger transparent" title="Delete this account"><i class="fa fa-trash"></i></button></a>
                    </th>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    <div class="mi-fooer">

    </div>
</div>
@endsection
