@extends('theme.theme')
@section('content')
<div class="row">
    <div class="mi-card">
      <div class="mi-header info"> LIST OF DELIVERY HUBS
        <a href="{{ route('delivery-hub.create') }}"><button class="butn success mi-right">ADD NEW DELIVERY HUB</button></a>
      </div>
      <div class="mi-body">
        <table class="table table-bordered mi-table" id="dataTable">
          <thead>
              <tr>
                  <th>ID</th>
                  <th>LOGO</th>
                  <th>BUSINESS TITLE</th>
                  <th>PROPITER NAME</th>
                  <th>EMAIL</th>
                  <th>PHONE</th>
                  <th>ACTION</th>
              </tr>
          </thead>

          <tbody>
              @foreach($data as $item)
              <tr>
                  <td>{{ $item->id }}</td>
                  <td><img width="50px" src="{{ $item->logo_url }}" alt=""></td>
                  <td>{{ $item->business_title }}</td>
                  <td>{{ $item->propiter_name }}</td>
                  <td>{{ $item->email }}</td>
                  <td>{{ $item->phone }}</td>
                  <th class="mi-action-button">
                      <a href="{{ route('delivery-hub.edit',['id'=>$item->id]) }}"><button class="butn butn-sm warning transparent" title="Edit"><i class="fas fa-edit"></i></button></a>
                      <a href="{{ route('order.list',['hub_id'=>$item->id]) }}"><button class="butn butn-sm info transparent" title="Orders"><i class="fas fa-box-open"></i></button></a>
                      @if($item->status == ACTIVE)
                      <a href="{{ route('global.change-status',['table'=>TBL_DELIVERY_HUB,'id'=>$item->id,'status'=>0]) }}"><button class="butn butn-sm danger transparent" title="Deactivate account"><i class="fa fa-times"></i></button></a>
                      @else
                      <a href="{{ route('global.change-status',['table'=>'TBL_DELIVERY_HUB','id'=>$item->id,'status'=>1]) }}"><button class="butn butn-sm success transparent" title="Activate Account"><i class="fa fa-check"></i></button></a>
                      @endif
                      <a onclick="return confirm('Are you sure to delete this account')" href="{{ route('delivery-hub.delete',['id'=>$item->id]) }}"><button class="butn butn-sm danger transparent" title="Delete this account"><i class="fa fa-trash"></i></button></a>
                  </th>
              </tr>
              @endforeach
          </tbody>
      </table>
      </div>
      <div class="mi-footer">
        <div class="float-right"></div>
      </div>
    </div>
  </div> @endsection
