@extends('theme.theme')
@section('content')
<div class="mi-card">
    <div class="mi-header info">
        All Contacts
        <a href="{{ route('admin.contact.create') }}">
            <button class="butn success mi-right">Add Contact</button>
        </a>
    </div>
    <div class="mi-body">
        <table class="table table-bordered mi-table" id="dataTable">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Icon</th>
                    <th>Title</th>
                    <th>Value</th>
                    <th>Link</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach($contacts as $contact)
                    <tr>
                        <td>{{ $contact->id }}</td>
                        <td><img src="{{ $contact->icon_url }}" width="35px" alt=""></td>
                        <td>{{ $contact->title }}</td>
                        <td>{{ $contact->value }}</td>
                        <td>{{ $contact->link }}</td>
                        <td>
                            <a href="{{ route('admin.contact.edit', ['id' => $contact->id]) }}">
                                <button class="butn butn-sm warning transparent">
                                    <i class="fa fa-edit"></i>
                                </button>
                            </a>
                            <a
                                onclick="deleteConfirm('{{ route('admin.contact.delete', ['id' => $contact->id]) }}','Are you sure to delete')">
                                <button class="butn butn-sm danger transparent">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
