@extends('theme.theme')
@section('content')
<div class="row">
    <div class="col-sm-6 m-auto">
        <div class="mi-card">
            <div class="mi-header info">
                {{ $contact ? 'Edit Contact' : 'Add Contact' }}
            </div>
            <form action="{{ route('admin.contact.store', ['id' => $contact?->id]) }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="mi-body">
                    <div class="form-group position-relative">
                        <label for="">Icon <b class="text-danger">*</b></label>
                        @if(isset($contact))
                        <div class="edit-image">
                            <a href="{{asset($contact->icon_url)}}">
                                <img src="{{asset($contact->icon_url)}}" alt="">
                            </a>
                        </div>
                        @endif
                        <input type="file" name="icon" id="icon" class="form-control edit-input" {{ $contact?'':'required' }}>
                    </div>
                    <div class="form-group">
                        <label for="">Title <b class="text-danger">*</b></label>
                        <input type="text" name="title" id="title" class="form-control" value="{{ $contact?->title }}"
                            required>
                    </div>
                    <div class="form-group">
                        <label for="">Value <b class="text-danger">*</b></label>
                        <input type="text" name="value" id="value" class="form-control" value="{{ $contact?->value }}"
                            required>
                    </div>
                    <div class="form-group">
                        <label for="">Link <b class="text-danger">*</b></label>
                        <input type="text" name="link" id="link" class="form-control" value="{{ $contact?->link }}"
                            required>
                    </div>

                </div>
                <div class="mi-footer d-flex justify-content-end">
                    <button type="submit" class="butn success">SAVE</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
