<div class="mi-card">
    <!--start of mi-fc-card-->
    <div class="mi-header {{ $status }} ">
        @if(isset($data))
        EDIT BRAND
        <a href="{{route('product-brand.create')}}">
            <button class="butn butn-sm mi-right success">ADD NEW BRAND</button>
        </a>
        @else
        ADD NEW BRAND
        @endif
    </div>
    <!--end of mi card header-->
    <form action="{{ route('product-brand.store') }}" method="POST" enctype="multipart/form-data">
        <div class="mi-body">
            <!--mi-card body started-->
            @csrf
            @if(isset($data))
            <input name="id" type="hidden" value="{{ $data->id }}">
            @endif
            <div class="row">
                <div class="form-group col-sm-3">
                    <label for="">COMPANY NAME</label>
                    <select name="company" id="company" class="form-control">
                        @foreach($companies as $company)
                            <option value="{{ $company->id }}" {{ isset($data)?($data->company_id == $company->id?'selected':''):'' }}>{{ $company->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group col-sm-4">
                    <label>BRAND NAME (ENGLISH) <b class="text-danger">*</b>
                    </label>
                    <input type="text" placeholder="BRAND NAME ENGLISH" name="brand_name_en" id="brand_name_en" class="form-control"
                        value="{{ isset($data)?$data->brand_name_en:old('brand_name_en') }}" required>
                </div>
                <div class="form-group col-sm-3">
                    <label>BRAND NAME (BANGLA) <b class="text-danger">*</b>
                    </label>
                    <input type="text" placeholder="BRAND NAME Bangla" name="brand_name_bn" id="brand_name_bn" class="form-control"
                        value="{{ isset($data)?$data->brand_name_bn:old('brand_name_bn') }}" required>
                </div>
                <div class="col-sm-2 m-auto">
                    <button type="submit" class="butn {{$status}} w-100 mt-2"> {{isset($data)?'UPDATE':'CREATE'}} </button>
                </div>
            </div>
        </div>
        <!--end of mi-card-body-->
    </form>
</div>
<!--end of mi-fc-card-->
