@extends('theme.theme')
@section('content')

<div class="row">
    <div class="col-sm-12 m-auto">
        <div class="mi-card">
            <div class="mi-header success">MANAGE APP SETTINGS</div>
            <form action="{{ route('app-settings.app.update') }}" method="POST">
                @csrf
                <div class="mi-body  row">

                    @foreach ($settings as $setting)
                        <div class="form-group col-sm-4">
                            <label for="">{{ $setting->name }}</label>
                            @if($setting->tag == 'comission_status' || $setting->tag == 'sms_status')
                                <div class="form-check form-switch">
                                    <input class="form-check-input mi-switch" name="{{ $setting->tag }}" type="checkbox" id="flexSwitchCheckDefault" value="1" {{ $setting->value==1?'checked':'' }}>
                                </div>
                            @else
                                <input type="text" name="{{ $setting->tag }}" class="form-control" value="{{ $setting->value }}">
                            @endif
                        </div>
                    @endforeach
                </div>
                <div class="mi-footer text-center">
                    <button type="submit" class="butn success">SAVE CHANGES</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection
