$(document).ready(function () {
    var sidebarClass = sessionStorage.getItem('sidebar-class');
    if (sidebarClass) {
        $('.mi-sidebar').removeClass('mi-collapse');
        $('.mi-sidebar').addClass(sidebarClass);
    }

    $("#openCloseSideBar").change(function () {
        console.log('here');
        if (this.checked) {
            $('.mi-sidebar').removeClass('mi-collapse');
            $('.mi-sidebar').addClass('mi-expand');
            sessionStorage.setItem('sidebar-class', 'mi-expand');
        } else {
            $('.mi-sidebar').removeClass('mi-expand');
            $('.mi-sidebar').addClass('mi-collapse');
            sessionStorage.setItem('sidebar-class', 'mi-collapse');
        }
        console.log(sessionStorage.getItem('sidebar-class'));
    });

    $('.mi-on-hover,.mi-on-hover>i').hover(function () {
        $(this).popover("show");
    });
    $('.mi-on-hover , .mi-on-hover>i').mouseout(function () {
        $(this).popover("hide");
    });

    $(".active").parent().addClass("show");
    $(".show").prev().addClass("main-active");

    $('.mi-content').click(function(){
        var drodown = $('.mi-collapse .submenu.show').prev('.dropdown')[0]
        if (drodown) {
            drodown.click();
        }

    });
});
var popoverTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="popover"]'))
var popoverList = popoverTriggerList.map(function (popoverTriggerEl) {
    return new bootstrap.Popover(popoverTriggerEl)
});


//close message

setTimeout(() => {
    $('.mi-smart-alert .btn-close').click();
}, 4000)



//close message



document.addEventListener("DOMContentLoaded", function () {
    document.querySelectorAll('.dropdown').forEach(function (element) {

        element.addEventListener('click', function (e) {

            let nextEl = element.nextElementSibling;
            let parentEl = element.parentElement;
            if (nextEl) {
                e.preventDefault();
                let mycollapse = new bootstrap.Collapse(nextEl);

                if (nextEl.classList.contains('show')) {
                    mycollapse.hide();
                } else {
                    mycollapse.show();
                    // find other submenus with class=show
                    var opened_submenu = parentEl.parentElement.querySelector('.submenu.show');
                    // if it exists, then close all of them
                    if (opened_submenu) {
                        new bootstrap.Collapse(opened_submenu);
                    }
                }
            }
        }); // addEventListener
    }) // forEach
});


var collection = [];
var params = JSON.parse($('#_params').val());
var params = Object.entries(params);
params.map((item, index, array) => {
    collection.push({
        name: item[0],
        value: item[1]
    });
})


function collectSearchData(event) {
    console.log(event);
    let nameExist = false;
    const name = event.target.name;
    const value = event.target.value;
    if (collection.length > 0) {
        collection.map((item, index, array) => {
            if (item.name == name) {
                nameExist = true;
                collection[index].value = value;
            }
        })
    }

    if (collection.length > 0) {
        if (!nameExist) {
            collection.push({
                name: name,
                value: value
            });
        }
    } else {
        collection.push({
            name: name,
            value: value
        });
    }
    console.log(collection);
}

function search() {
    var url = '?';
    if (collection.length > 0) {
        collection.map((item, index, array) => {
            if (item.value !== '') {
                url += item.name + '=' + item.value + '&'
            }
        });
        window.location.href = url;
    }
}

function loader() {
    $('.mi-loader').removeClass('d-none');
    return true;
}

// CKEDITOR.ClassicEditor.create(document.getElementById("editor"), {
//     // https://ckeditor.com/docs/ckeditor5/latest/features/toolbar/toolbar.html#extended-toolbar-configuration-format
//     toolbar: {
//         items: [
//             'heading', '|',
//             'bold', 'italic', 'strikethrough', 'underline', 'code', 'subscript', 'superscript', 'removeFormat', '|',
//             'bulletedList', 'numberedList', 'todoList', '|',
//             'outdent', 'indent', '|',
//             'undo', 'redo',
//             '-',
//             'fontSize', 'fontFamily', 'fontColor', 'fontBackgroundColor', 'highlight', '|',
//             'alignment', '|',
//             'link', 'insertImage', 'blockQuote', 'insertTable', 'mediaEmbed', 'codeBlock', 'htmlEmbed', '|',
//             'specialCharacters', 'horizontalLine', 'pageBreak', '|',
//             'textPartLanguage', '|',
//             'sourceEditing'
//         ],
//         shouldNotGroupWhenFull: true
//     },
//     // Changing the language of the interface requires loading the language file using the <script> tag.
//     // language: 'es',
//     list: {
//         properties: {
//             styles: true,
//             startIndex: true,
//             reversed: true
//         }
//     },
//     // https://ckeditor.com/docs/ckeditor5/latest/features/headings.html#configuration
//     heading: {
//         options: [
//             { model: 'paragraph', title: 'Paragraph', class: 'ck-heading_paragraph' },
//             { model: 'heading1', view: 'h1', title: 'Heading 1', class: 'ck-heading_heading1' },
//             { model: 'heading2', view: 'h2', title: 'Heading 2', class: 'ck-heading_heading2' },
//             { model: 'heading3', view: 'h3', title: 'Heading 3', class: 'ck-heading_heading3' },
//             { model: 'heading4', view: 'h4', title: 'Heading 4', class: 'ck-heading_heading4' },
//             { model: 'heading5', view: 'h5', title: 'Heading 5', class: 'ck-heading_heading5' },
//             { model: 'heading6', view: 'h6', title: 'Heading 6', class: 'ck-heading_heading6' }
//         ]
//     },
//     // https://ckeditor.com/docs/ckeditor5/latest/features/editor-placeholder.html#using-the-editor-configuration
//     // https://ckeditor.com/docs/ckeditor5/latest/features/font.html#configuring-the-font-family-feature
//     fontFamily: {
//         options: [
//             'default',
//             'Arial, Helvetica, sans-serif',
//             'Courier New, Courier, monospace',
//             'Georgia, serif',
//             'Lucida Sans Unicode, Lucida Grande, sans-serif',
//             'Tahoma, Geneva, sans-serif',
//             'Times New Roman, Times, serif',
//             'Trebuchet MS, Helvetica, sans-serif',
//             'Verdana, Geneva, sans-serif'
//         ],
//         supportAllValues: true
//     },
//     // https://ckeditor.com/docs/ckeditor5/latest/features/font.html#configuring-the-font-size-feature
//     fontSize: {
//         options: [ 10, 12, 14, 'default', 18, 20, 22 ],
//         supportAllValues: true
//     },
//     // Be careful with the setting below. It instructs CKEditor to accept ALL HTML markup.
//     // https://ckeditor.com/docs/ckeditor5/latest/features/general-html-support.html#enabling-all-html-features
//     htmlSupport: {
//         allow: [
//             {
//                 name: /.*/,
//                 attributes: true,
//                 classes: true,
//                 styles: true
//             }
//         ]
//     },
//     // Be careful with enabling previews
//     // https://ckeditor.com/docs/ckeditor5/latest/features/html-embed.html#content-previews
//     htmlEmbed: {
//         showPreviews: true
//     },
//     // https://ckeditor.com/docs/ckeditor5/latest/features/link.html#custom-link-attributes-decorators
//     link: {
//         decorators: {
//             addTargetToExternalLinks: true,
//             defaultProtocol: 'https://',
//             toggleDownloadable: {
//                 mode: 'manual',
//                 label: 'Downloadable',
//                 attributes: {
//                     download: 'file'
//                 }
//             }
//         }
//     },
//     // https://ckeditor.com/docs/ckeditor5/latest/features/mentions.html#configuration

//     // The "super-build" contains more premium features that require additional configuration, disable them below.
//     // Do not turn them on unless you read the documentation and know how to configure them and setup the editor.
//     removePlugins: [
//         // These two are commercial, but you can try them out without registering to a trial.
//         // 'ExportPdf',
//         // 'ExportWord',
//         'CKBox',
//         'CKFinder',
//         'EasyImage',
//         // This sample uses the Base64UploadAdapter to handle image uploads as it requires no configuration.
//         // https://ckeditor.com/docs/ckeditor5/latest/features/images/image-upload/base64-upload-adapter.html
//         // Storing images as Base64 is usually a very bad idea.
//         // Replace it on production website with other solutions:
//         // https://ckeditor.com/docs/ckeditor5/latest/features/images/image-upload/image-upload.html
//         // 'Base64UploadAdapter',
//         'RealTimeCollaborativeComments',
//         'RealTimeCollaborativeTrackChanges',
//         'RealTimeCollaborativeRevisionHistory',
//         'PresenceList',
//         'Comments',
//         'TrackChanges',
//         'TrackChangesData',
//         'RevisionHistory',
//         'Pagination',
//         'WProofreader',
//         // Careful, with the Mathtype plugin CKEditor will not load when loading this sample
//         // from a local file system (file://) - load this site via HTTP server if you enable MathType.
//         'MathType',
//         // The following features are part of the Productivity Pack and require additional license.
//         'SlashCommand',
//         'Template',
//         'DocumentOutline',
//         'FormatPainter',
//         'TableOfContents',
//         'PasteFromOfficeEnhanced'
//     ]
// });
function deleteConfirm(url,subtitle){
    swal({
        title: "Are you sure?",
        text: subtitle??"Are you sure to perform this action",
        icon: "warning",
        buttons: ["No", subtitle?"Yes ! Sure":"Yes Delete"],
        dangerMode: true,
    })
    .then((willDelete) => {
        if (willDelete) {
            window.location.href = url;
        }
    });
}
function _confirm(url,subtitle){
    swal({
        title: "Are you sure?",
        text: subtitle??"Are you sure to perform this action",
        icon: "success",
        buttons: ["No", subtitle?"Yes ! Sure":"Yes Delete"],
        dangerMode: true,
    })
    .then((willDelete) => {
        if (willDelete) {
            window.location.href = url;
        }
    });
}

