<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('fund_requests', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('hub_id')->nullable();
            $table->float('amount');
            $table->float('after_balance')->default(0);
            $table->string('description')->nullable();
            $table->integer('status')->comment('0=Pending,1=Accepted,2=Rejected')->default(0);
            $table->string('type')->nullable();
            $table->timestamps();
            $table->foreign('hub_id') // Defines the foreign key relationship
                ->references('id') // References the `id` column
                ->on('delivery_hubs') // Specifies the related table
                ->onDelete('set null'); // Sets `vendor_id` to null if the related vendor is deleted
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fund_requests');
    }
};
