<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('shops', function (Blueprint $table) {
            $table->dropColumn('user_id'); // Drops the existing `user_id` column
            $table->unsignedBigInteger('vendor_id')->nullable()->after('id'); // Adds the new `vendor_id` column
            $table->foreign('vendor_id') // Defines the foreign key relationship
                ->references('id') // References the `id` column
                ->on('vendors') // Specifies the related table
                ->onDelete('set null'); // Sets `vendor_id` to null if the related vendor is deleted
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('shops', function (Blueprint $table) {
            //
        });
    }
};
