<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('tbl_product', callback: function (Blueprint $table) {
            $table->text('tag')->after('product_form')->nullable()->comment('is this product allows free delivery');
            $table->integer('is_free_delivery')->after('tag')->nullable()->comment('is this product allows free delivery');
            $table->integer('free_delivery_quantity')->after('is_free_delivery')->nullable()->comment('for how many quantity he will get free delivery');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('tbl_products', function (Blueprint $table) {
            //
        });
    }
};
