<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_orders', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('order_number');
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('dropshipper_id')->nullable();
            $table->integer('qty');
            $table->string('payment_method');
            $table->float('order_total');
            $table->float('tax')->default(0);
            $table->float('delivery_charge')->default(0);
            $table->integer('status')->default(1);
            $table->integer('payment_status')->default(0);
            $table->unsignedBigInteger('hub_id')->nullable();
            $table->unsignedBigInteger('coupon_id')->nullable();
            $table->float('discount_amount')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_orders');
    }
};
