<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_product', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('category_id');
            $table->unsignedBigInteger('subcategory_id');
            $table->string('product_name_en');
            $table->string('product_name_bn');
            $table->text('details');
            $table->timestamp('warranty_time')->nullable();
            $table->timestamp('refund_time')->nullable();
            $table->float('original_price')->default(0);
            $table->float('sale_price')->default(0);
            $table->float('agent_price')->default(0);
            $table->float('dropshipper_min_price')->default(0);
            $table->float('dropshipper_max_price')->default(0);
            $table->text('sizes')->nullable();
            $table->text('colors')->nullable();
            $table->integer('status');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_product');
    }
};
