<?php
// database/migrations/YYYY_MM_DD_create_tbl_users_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('tbl_users', function (Blueprint $table) {
            $table->id();
            $table->string('image')->nullable();
            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('email')->nullable();
            $table->string('phone');
            $table->string('password')->nullable();
            $table->string('otp')->nullable();
            $table->timestamp('otp_last_generated_at')->nullable();
            $table->decimal('common_wallet', 10, 2)->default(0);
            $table->decimal('cash_wallet', 10, 2)->default(0);
            $table->integer('status')->default(1);
            $table->integer('role')->default(4);
            $table->string('refer_token')->nullable();
            $table->unsignedBigInteger('parent_id')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down()
    {
        Schema::dropIfExists('tbl_users');
    }
};
