<?php

namespace App\Services;

use Kreait\Firebase\Factory;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification;
use Illuminate\Support\Facades\Log;


class FCMService
{
    protected $messaging;

    public function __construct()
    {
        // Initialize Firebase Messaging
        $factory = (new Factory)
            ->withServiceAccount(base_path('storage/app/json/firebase_credentials.json'));

        $this->messaging = $factory->createMessaging();
    }

    public function sendBatchNotifications(array $users)
    {
        $messages = [];

        foreach ($users as $user) {
            $deviceToken = $user['device_token'];
            $title = $user['title'];
            $body = $user['body'];

            $notification = Notification::create($title, $body);
            $message = CloudMessage::withTarget('token', $deviceToken)
                ->withNotification($notification);

            $messages[] = $message;
        }

        // Send all messages in a batch
        $this->messaging->sendAll($messages);
    }


    public function sendMulticastFCMNotifications(array $fcmTokens, CloudMessage $message)
    {
        try {
            // Use sendMulticast to send the same message to multiple tokens
            $result = $this->messaging->sendMulticast($message, $fcmTokens);

            // Log successes and failures
            if ($result->failures()->count() > 0) {
                foreach ($result->failures() as $failure) {
                    Log::error('Failed to send to ' . $failure->target()->token() . ': ' . $failure->error()->getMessage());
                }
            }

            Log::info('Successfully sent notifications to ' . $result->successes()->count() . ' users.');

        } catch (\Throwable $e) {
            Log::error('Failed to send FCM notifications: ' . $e->getMessage());
        }
    }


    public function sendShareProfitNotification($users,$product,$isVip){
        // $fcmTokens = $users->whereNotNull('fcm_token')->pluck('fcm_token')->toArray();
        $fcmTokens = ['cHWX_P0fSGeY7JRmskGXqq:APA91bE16RE3_exc1jGJktIfQKFC4FRr4Cc5dNm40PhUu-WRY3ieQs9USA-6Gd6ii4TD7yyv-n_ylDWk34zr9S7EOqJIPwWGImGV5syt3KeIXho4NsUrpRF12L_dnK7_Jav4oId2RdDB'];
        if(!empty($fcmTokens)){
            // Create the notification payload once
            if(!$isVip){
                $message = 'Congratulations! You received profit from ' . $product->name_en.' product';
            }else{
                if($product){
                    $message = 'Congratulations! You received bonus profit from ' . $product->name_en.' product';
                }else{
                    $message = 'Congratulations! You received bonus profit';
                }
            }

            $message = CloudMessage::new()
                ->withNotification([
                    'title' => 'Profit Share',
                    'body' => $message,
                    'android_channel_id'=>'gcb_partner'
                ])
                ->withData([
                    'notification_type' => 'share_profit',
                ])->withHighestPossiblePriority();


            // Send the message to all users using sendMulticast (same message to multiple tokens)
            $this->sendMulticastFCMNotifications($fcmTokens, $message);
        }
    }


    public function sendNotification ($fcm_token,$notification,$data){
        try{
            $notification['android_channel_id']="gcb_partner";
            $message = CloudMessage::withTarget('token', $fcm_token)
                ->withNotification($notification)
                ->withData($data)
                ->withHighestPossiblePriority();

            // Send the message to the user
            $this->messaging->send($message);
        }catch(\Exception $e){
            Log::error('Failed to send message . fcm_token:'.$fcm_token);
        }
    }
}
