<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Vendor extends Model
{
    use HasFactory,SoftDeletes;

    public function scopeFilter($query){
        $query->whereNull('deleted_at')->latest();
    }

    public function shop(){
        return $this->belongsTo(Shop::class,'id','vendor_id');
    }
}
