<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserAddress extends Model
{
    use HasFactory;
    public $fillable = [
        'name',
        'phone',
        'email',
        'address',
        'division_id',
        'district_id',
        'upazila_id',
        'area_id',
        'user_id',
        'type',
        'is_default'
    ];

    public function division(){
        return $this->belongsTo(Division::class,'division_id','id');
    }

    public function district(){
        return $this->belongsTo(District::class,'district_id','id');
    }

    public function upazila(){
        return $this->belongsTo(Upazila::class,'upazila_id','id');
    }

    public function area(){
        return $this->belongsTo(Area::class,'area_id','id');
    }
}
