<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProductCategory extends Model
{
    protected $table = "tbl_product_category";
    public $primaryKey = "id";
    protected $appends = ["category_image_url"];
    public $guarded = [];
    public function getCategoryImageUrlAttribute()
    {
        if ($this->category_image) {
            return url("images/" . $this->category_image);
        } else {
            return "https://upload.wikimedia.org/wikipedia/commons/thumb/a/ac/No_image_available.svg/1024px-No_image_available.svg.png";
        }
    }


    public function products(){
        return $this->hasMany(Product::class,'category_id');
    }

    public function basicProducts(){
        return $this->hasMany(ProductBasicInfo::class,'category_id')->where('status',ACTIVE);
    }

    public function images(){
        return $this->hasMany(CategoryImages::class,'category_id');
    }

    public function subcategories(){
        return $this->hasMany(ProductSubcategory::class,'category_id')->where('status',ACTIVE);
    }

    public function getNameAttribute(){
        if(getLang()=='bn')
            return $this->category_name_bn;
        else
            return $this->category_name_en;
    }
}
