<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrderItemHistory extends Model
{
    use HasFactory;
    protected $table = 'tbl_order_items_history';
    public $guarded = [];

    public function item(){
        return $this->belongsTo(Product::class,'product_id')->select('id','product_name_en');
    }

    public function getStatusTextAttribute(){
        if($this->status == RETURN_REQUEST_PENDING){
            return 'Request Pending';
        }else if($this->status == RETURN_REQUEST_ACCEPTED){
            return 'Request Accepted';
        }else if($this->status == RETURN_REQUEST_REJECTED){
            return 'Request Rejected';
        }else if($this->status == REFUNDED_BY_SELLER){
            return 'Item Retuned';
        }
    }
}
