<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Offer extends Model
{
    protected $table = "tbl_offers";
    public $primaryKey = "id";
    public $guarded = [];

    protected $appends = ["image_url"];
    public function getImageUrlAttribute()
    {
        if ($this->image) {
            return url("images/" . $this->image);
        } else {
            return noImage();
        }
    }

    public function products(){
    }
}
