<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FundRequest extends Model
{
    use HasFactory;

    public $fillable = ['amount','description','type','hub_id','status','reject_reason'];

    public function scopeStockistFilter($query){
        $query->where('type','stockist')
        ->where('hub_id',auth('hub')->id());
    }

    public function hub(){
        return $this->belongsTo(DeliveryHub::class,'hub_id','id');
    }

    public function getStatusTextAttribute(){
        if($this->status == FUND_REQUEST_PENDING){
            return 'Pending';
        }elseif($this->status == FUND_REQUEST_ACCEPTED){
            return 'Accepted';
        }elseif($this->status == FUND_REQUEST_REJECTED){
            return 'Rejected';
        }
    }
}
