<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DellerShop extends Model
{
    protected $table = "tbl_deller_shop";
    public $primaryKey = "id";
    protected $appends = ["shop_logo_url"];

    protected $guarded = [];
    public function getShopLogoUrlAttribute()
    {
        if ($this->shop_logo) {
            return url("images/" . $this->shop_logo);
        } else {
            return "https://upload.wikimedia.org/wikipedia/commons/thumb/a/ac/No_image_available.svg/1024px-No_image_available.svg.png";
        }
    }
}
