<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;

class DeliveryHub extends Authenticatable
{
    public $primaryKey = "id";
    protected $appends = ["logo_url"];
    public $guarded = [];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    public function getLogoUrlAttribute()
    {
        if ($this->logo) {
            return url("images/" . $this->logo);
        } else {
            return noImage();
        }
    }

    public function getHubProfileUrlAttribute()
    {
        if ($this->profile_photo) {
            return url("images/" . $this->profile_photo);
        } else {
            return noImage();
        }
    }
    public function getHubTradeLicenseUrlAttribute()
    {
        if ($this->trade_license) {
            return url("images/" . $this->trade_license);
        } else {
            return noImage();
        }
    }
    public function getHubNidUrlAttribute()
    {
        if ($this->nid) {
            return url("images/" . $this->nid);
        } else {
            return noImage();
        }
    }
    public function getHubImageUrlAttribute()
    {
        if ($this->hub_image) {
            return url("images/" . $this->hub_image);
        } else {
            return noImage();
        }
    }


    public function _businessDivision(){
        return $this->belongsTo(Division::class,'business_division','id');
    }

    public function _businessDistrict(){
        return $this->belongsTo(Districts::class,'business_district','id');
    }

    public function stockistAreas(){
        return $this->hasMany(StockistArea::class,'hub_id','id');
    }

    public function getSelectedAreasAttribute(){
        return $this->stockistAreas->flatten()->pluck('area');
    }

    public function getAreaNamesAttribute(){
        return $this->selected_areas->pluck('area_name')->toArray();
    }

    public function getAreaIdsAttribute(){
        return $this->selected_areas->pluck('id')->toArray();
    }
}
