<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Contact extends Model
{
    use HasFactory;
    public $fillable = ['icon','title','value','link'];
    public $appends = ['icon_url'];

    public function getIconUrlAttribute()
    {
        if ($this->icon) {
            return url("images" . $this->icon);
        } else {
            return noImage();
        }
    }
}
