<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Company extends Model
{
    use HasFactory;
    public $table = 'tbl_company';

    public function products(){
        return $this->hasMany(Product::class,'company_id');
    }

    public function basicProducts(){
        return $this->hasMany(ProductBasicInfo::class,'company_id')->where('status',ACTIVE);
    }

    public function brands(){
        return $this->hasMany(Brands::class,'company_id','id');
    }
}
