<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Brands extends Model
{
    use HasFactory;
    protected $table = 'tbl_brand';
    public $guarded = [];


    public function products(){
        return $this->hasMany(Product::class,'brand_id');
    }

     public function basicProducts(){
        return $this->hasMany(ProductBasicInfo::class,'brand_id')->where('status',ACTIVE);
    }

    public function company(){
        return $this->belongsTo(Company::class,'company_id');
    }

    public function getNameAttribute(){
        if(getLang()=='bn')
            return $this->brand_name_bn;
        else
            return $this->brand_name_en;
    }
}
