<?php

namespace App\Http\Resources\Api;

use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Request;

class RankResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */




    public function toArray($request)
    {
        return [
            'id'=>$this->id,
            'name'=>$this->name,
            'type'=>getRankTypes()[$this->type],
            'team_A_amount'=>$this->team_A_amount,
            'team_B_amount'=>$this->team_B_amount,
            // 'user_team_A_amount' => $this->type == 1
            //     ? $this->teamAordersTotal
            //     : $this->teamAUsers->where('rank_id', $this->id-1)->count(),
            // 'user_team_B_amount' => $this->type == 1
            //     ? $this->teamBordersTotal
            //     : $this->teamBUsers->where('rank_id', $this->id-1)->count(),
        ];
    }

    public function with($request): array
    {
        return [
            'id'=>1
        ];

    }
}
