<?php

namespace App\Http\Resources\Api;

use Illuminate\Http\Resources\Json\JsonResource;

class ProductCardInfoResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id'=>$this->id,
            'product_name'=>$this->basicInfo->name,
            'customer_discount'=>$this->customer_discount,
            'original_price'=>$this->original_price,
            'sale_price'=>$this->sale_price,
            'actual_sell_price'=>$this->actual_sell_price,
            'thumbnail_url'=>$this->thumbnailImage?->file_url,
            'is_free_delivery'=>(bool)$this->is_free_delivery,
            'tag'=>$this->tag,
            'total_sold'=>formatNumber($this->total_sold),
            'type'=>$this->product_type == 1?
                    collect(productType())->where('id',$this->type)->value('name'):
                    null,
        ];
    }
}
