<?php

namespace App\Http\Resources\Api;

use Illuminate\Http\Resources\Json\JsonResource;

class CartItemResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'product_id'=>$this->id,
            'product_name'=>$this->basicInfo->name,
            'customer_discount'=>$this->customer_discount,
            'original_price'=>$this->original_price,
            'sale_price'=>$this->sale_price,
            'actual_sell_price'=>$this->actual_sell_price,
            'thumbnail_url'=>$this->thumbnailImage?->file_url,
            'stock'=>$this->stock,
            'shop_id'=>$this?->shop?->id,
        ];
    }
}
