<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ProductCategoryRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }
    public function rules()
    {
        if (Request()->has("id")) {
            return [
                'category_name_en' => 'required|unique:tbl_product_category,category_name_en,' . request('id'),
                'category_name_bn' => 'required|unique:tbl_product_category,category_name_bn,' . request('id'),
                "status" => "required",
                "category_image" => "nullable|image",
                
            ];
        } else {
            return [
                "category_name_en" => "required|unique:tbl_product_category,category_name_en",
                "category_name_bn" => "required|unique:tbl_product_category,category_name_bn",
                "category_image" => "required|image",
                "status" => "required",
            ];
        }
    }
}
