<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\CartItemRequest;
use App\Http\Resources\Api\CartItemResource;
use App\Models\Product;
use App\Models\ProductColor;
use App\Models\Shop;
use Faker\Core\Color;
use Illuminate\Http\Request;

class CartController extends Controller
{
    public function getCartItems(CartItemRequest $cartItemRequest){
        $productIds = collect($cartItemRequest->items)->map(function($item){
            return $item['product_id'];
        })->toArray();

        $shopIds = collect($cartItemRequest->items)->map(function($item){
            return $item['shop_id'];
        })->unique()->toArray();


        $shops = Shop::whereIn('id',$shopIds)->with('products',function($query)use($productIds){
            $query->whereIn('id',$productIds)
            ->where('status',ACTIVE)
            ->where('stock','>',0)
            ->withWhereHas('basicInfo');
        })->get();

        $isDeliveryInsideDhaka = false;
        if(auth('sanctum')->check() && in_array(auth('sanctum')->user()->division_id,DELIVERY_INSIDE_DHAKA)){
            $isDeliveryInsideDhaka = true;
        }

        $cartItems = [];
        foreach($shops as $shop){
            $isDeliveryFree = false;
            $store = [
                'store_id'=>$shop->id,
                'store_name'=>$shop->name,
                'delivery_charge'=>0,
                'items'=>[]
            ];
            foreach($shop->products as $product){
                $cartItem = collect($cartItemRequest->items)->where('product_id',$product->id)->first();
                $itemInfo = new CartItemResource($product);
                $itemInfo = $itemInfo->toArray(request());
                $itemInfo['quantity']=$cartItem['quantity'] > $product->stock?$product->stock:$cartItem['quantity'];
                $itemInfo['size']=$cartItem['size'] ?? null;
                $itemInfo['color_id']=$cartItem['color_id'] ?? null;
                if($cartItem['color_id']){
                    $productColor = ProductColor::with('color')->where('id',$cartItem['color_id'])->first();
                    if($productColor){
                        $itemInfo['thumbnail_url']=$productColor->image_url;
                        $itemInfo['color_name']=$productColor->color->image_url;
                    }
                }
                $store['items'][] = $itemInfo;
                if($product->is_free_delivery){
                    $isDeliveryFree = true;
                }
            }

            if($isDeliveryFree){
                $store['delivery_charge'] = 0;
            }else{
                if($isDeliveryInsideDhaka){
                    $store['delivery_charge'] = $shop->delivery_charge_inside_dhaka ?? 0;
                }else{
                    $store['delivery_charge'] = $shop->delivery_charge_outside_dhaka ?? 0;
                }
            }

            $cartItems[]=$store;
        }

         return response()->json([
            'items'=>$cartItems,
            'total_cart_items'=>count($cartItems),
            'is_logged_in'=>auth('sanctum')->check()?true:false,
        ]);

    }

    public function addtoWishList(){

    }

    public function getWishlistItems(){

    }
}
