<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\UserAddressRequest;
use App\Http\Resources\Api\AddressResource;
use App\Models\Area;
use App\Models\Division;
use App\Models\StockistArea;
use App\Models\UserAddress;
use Illuminate\Http\Request;

class AddressController extends Controller
{
    public function list($type){
        $addresses = UserAddress::with(['division','district','upazila'])
                ->where('user_id',auth()->id())
                ->where('type',$type)
                ->orderByDesc('id')->get();
        return response()->json(['addresses'=>AddressResource::collection($addresses)],200);
    }

    public function store(UserAddressRequest $userAddressRequest){
        $hasDefault = UserAddress::where('user_id',auth()->id())->where('type',$userAddressRequest->type)->where('is_default',1)->first();
        $data = [
            'name'=>$userAddressRequest->name,
            'phone'=>$userAddressRequest->phone,
            'email'=>$userAddressRequest->email,
            'address'=>$userAddressRequest->address,
            'division_id'=>$userAddressRequest->division,
            'district_id'=>$userAddressRequest->district,
            'upazila_id'=>$userAddressRequest->upazila,
            'area_id'=>$userAddressRequest->area,
            'user_id'=>auth()->id(),
            'is_default'=>$hasDefault?0:1,
            'type'=>$userAddressRequest->type
        ];

        UserAddress::updateOrCreate(['id'=>$userAddressRequest->id],$data);

        return response()->json(['message'=>'Address saved successfully'],200);
    }


    public function edit($id){
        $address = UserAddress::where('user_id',auth()->id())->find($id);
        if($address){
            return response()->json(['address'=>$address],200);
        }else{
            return response()->json(['message'=>'Address not found'],404);
        }
    }

    public function divisions(){
        if(request('type') == 'mystore'){
            $areas = Area::get();
            $divisions = $areas->pluck('division_id')->toArray();
            $districts = $areas->pluck('district_id')->toArray();
            $upazilas = $areas->pluck('upazila_id')->toArray();
            $divisions = Division::with(['districts'=>function($query)use($districts){
                $query->whereIn('id',$districts);
            },'districts.upazilas'=>function($query)use($upazilas){
                $query->whereIn('id',$upazilas);
            },'districts.upazilas.areas'])->whereIn('id',$divisions)
            ->select('id','name')->get();
        }else{
            $divisions = Division::with(['districts.upazilas'])->select('id','name')->get();
        }
        return response()->json(['divisions'=>$divisions],200);
    }

    public function delete($id){
        UserAddress::where('user_id',auth()->id())->where('id',$id)->delete();
        return response()->json(['message'=>'Address deleted successfully'],200);
    }

    public function defaultAddress($type){
        $address = UserAddress::where('user_id',auth()->id())->where('type',$type)->where('is_default',1)->first();
        if($address){
            return response()->json(['address'=>new AddressResource($address)],200);
        }else{
            return response()->json(['address'=>null],200);
        }
    }

    public function selectShippingAddress(Request $request){
        $address = UserAddress::where('user_id',auth()->id())
                ->where('id',$request->id)
                ->first();
        UserAddress::where('user_id',auth()->id())->where('type',$request->type)->update(['is_default' => 0]);
        $address->update(['is_default' => 1]);
        return response()->json(['message'=>'Address selected successfully'],200);
    }
}
