<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\CashWalletHistory;
use App\Models\ComissionWalletHistory;
use App\Models\User;
use App\Models\Withdrawal;
use Illuminate\Http\Request;
use DB;

class WithdrawalController extends Controller
{
    public function list(){
        $data = Withdrawal::filter()->get();
        return view('admin.withdrawal.list',compact('data'));
    }

    public function changeStatus($id,$status,Request $request){
        DB::beginTransaction();
        try{
            $withdrawRequest = Withdrawal::where('id',$request->id)->where('status',0)->first();
            if($withdrawRequest){
                if($request->status == REJECTED){
                    User::where('id',$withdrawRequest->user_id)->increment($withdrawRequest->wallet_type,$withdrawRequest->amount+$withdrawRequest->charge);
                    $history = [
                        'user_id'=>$withdrawRequest->user_id,
                        'payment_method'=>'bkash',
                        'transaction_id'=>$request->transaction_id,
                        'amount'=>($withdrawRequest->amount+$withdrawRequest->charge),
                        'message'=>'Your withdrawal reqest has been cancelled',
                        'transaction_type'=>WITHDRAWAL
                    ];
                    if($withdrawRequest->wallet_type == CASH_WALLET){
                        CashWalletHistory::create($history);
                    }else if($withdrawRequest->wallet_type == COMISSION_WALLET){
                        ComissionWalletHistory::create($history);
                    }


                    $withdrawRequest->update([
                        'status'=>REJECTED,
                        'note'=>$request->note?$request->note:'Rejected'
                    ]);


                }else{
                    $withdrawRequest->update([
                        'status'=>ACCEPTED,
                        'transaction_id'=>$request->transaction_id,
                        'note'=>$request->note
                    ]);
                }

                DB::commit();

                return redirect()->back()->with('success','Request '.$request->status>0?'Accepted':'Rejected'.' Successfully');
            }else{
                return redirect()->back()->with('error','Sorry , Request not found');
            }
        }catch(\Exception $e){
            return $e;
        }
    }
}
