<?php

namespace App\Http\Controllers\admin;


use App\Http\Requests\SellerRequest;
use App\Models\User;
use App\Models\Shop;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use App\Http\Controllers\Controller;
use App\Models\Vendor;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;


class SellerController extends Controller
{
    public function list(){
        $data  = Vendor::filter()->where('type',SELLER)->get();
        return view('admin.seller.list',compact('data'));
    }

    public function create(){
        $data = null;
        $data['seller']=null;
        $data = (object)$data;
        return view('admin.seller.form',compact('data'));
    }

    public function edit($id){
        $data  = Vendor::where('id',$id)->where('type',SELLER)->first();
        if(!$data){
            abort(404);
        }
        return view('admin.seller.form',compact('data'));
    }

    public function delete($id){
        User::where('id',$id)->update(['deleted_at'=>Carbon::now()]);
        toastr()->success('User Deleted Successfully');
    }

    public function store(SellerRequest $request){
        DB::beginTransaction();
        try{
            $uuid = Str::upper(Str::random(10));
            $dellerInfo=[
                'first_name'=>$request->first_name,
                'last_name'=>$request->last_name,
                'email'=>$request->email,
                'phone'=>$request->phone,
                'status'=>$request->status,
                'type'=>SELLER,
                'refer_token'=>$uuid
            ];

            if($request->password){
                $dellerInfo['password'] = Hash::make($request->password);
            }


            $dellerShopInfo = [
                'shop_name_en'=>$request->shop_name_en,
                'shop_name_bn'=>$request->shop_name_bn,
                'shop_address'=>$request->shop_address,
                'lat'=>$request->lat,
                'lon'=>$request->lon,
                'status'=>$request->shop_status,
            ];

            if ($request->hasFile("deller_image")) {
                if ($request->has("id")) {
                    $deller_image = User::where(
                        "id",
                        $request->id
                    )->value("image");
                    if ($deller_image) {
                        deleteImage("", $deller_image);
                    }
                }
                $deller_image = imageUpload(
                    $request->file("deller_image"),
                    '/deller/'
                );
                $dellerInfo["image"] = $deller_image;
            }


            if ($request->hasFile("shop_logo")) {
                if ($request->has("id")) {
                    $deller_shop_logo = User::where(
                        "id",
                        $request->id
                    )->value("image");
                    if ($deller_shop_logo) {
                        deleteImage("", $deller_shop_logo);
                    }
                }
                $deller_shop_logo = imageUpload(
                    $request->file("shop_logo"),
                    '/deller/'
                );
                $dellerShopInfo["shop_logo"] = $deller_shop_logo;
            }


            if($request->id > 0){
                Vendor::where('id',$request->id)->update($dellerInfo);
                Shop::where('vendor_id',$request->id)->update($dellerShopInfo);
            }else{
                $dellerId = Vendor::insertGetId($dellerInfo);
                $dellerShopInfo['vendor_id']=$dellerId;
                Shop::create($dellerShopInfo);
            }
            DB::commit();
            return redirect()->back()->with('success','Seller information save successfully');
        }catch(\Exception $e){
            return $e;
        }
    }
}
