<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\OrderItemHistory;
use App\Models\OrderItems;
use App\Models\ReturnedItem;
use App\Models\User;
use HtmlSanitizer\Extension\Iframe\Sanitizer\IframeSrcSanitizer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ReturnController extends Controller
{

    public function list(){
        $items = ReturnedItem::with(['user','orderItem.shop'])->withWhereHas('orderItem.product')->orderBy('id','DESC')->get();
        return view('admin.return.list',compact('items'));
    }

    public function view($id){
        $details = ReturnedItem::where('id',$id)->with(['user','orderItem.shop.user'])->withWhereHas('orderItem.product')->orderBy('id','DESC')->first();
        return view('admin.return.view',compact('details'));
    }

    public function changeStatus(Request $request){
        DB::beginTransaction();
        try{
            $request->validate([
                'id'=>'required',
                'status'=>'required',
                'admin_note'=>'required'
            ]);

            $returnRequest = ReturnedItem::where('id',$request->id)->first();
            $data = [
                'status'=>$request->status,
                'admin_note'=>$request->admin_note,
            ];

            $orderItemReturnMap = [
                RETURN_REQUEST_ACCEPTED=>RETURN__REQUEST_ACCEPTED,
                RETURN_REQUEST_REJECTED=>RETURN_REQUEST_CANCELLED,
                REFUNDED_BY_SELLER=>RETURNED,
            ];

            $orderItem = OrderItems::where('id',$returnRequest->order_item_id)->first();
            $orderItem->update(['status'=>$orderItemReturnMap[$request->status]]);
            if($request->status == REFUNDED_BY_SELLER){
                $orderItem->delete();
                $order = Order::where('id',$orderItem->order_id)->first();
                $itemPrice = (float)$orderItem->price*$orderItem->qty;
                $order->decrement('order_total',$itemPrice);
                User::where('id',$order->user_id)->increment('cash_wallet',$itemPrice);
            }

            OrderItemHistory::create([
                'order_id'=> $orderItem->order_id,
                'order_item_id'=> $orderItem->id,
                'product_id'=> $orderItem->product_id,
                'hub_id'=>1,
                'note'=>$request->admin_note,
                'status'=>$orderItemReturnMap[$request->status]
            ]);


            $returnRequest->update($data);

            DB::commit();
            flash()->success('Action submitted properly');
            return redirect()->back();
        }catch(\Exception $e){
            return $e;
        }
    }

    public function refunded($id){
        ReturnedItem::where('id',$id)->update(['status'=>REFUNDED_BY_SELLER]);
        flash()->success('Action submitted properly');
        return redirect()->back();
    }
}
