<?php
namespace App\Http\Controllers\admin;
use App\Http\Requests\ProductCategoryRequest;
use App\Models\ProductCategory;
use App\Http\Controllers\Controller;
use App\Models\CategoryImages;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use DB;

class ProductCategoryController extends Controller
{
    public $model;
    public function __construct()
    {
        $this->model = new ProductCategory();
    }
    public function create()
    {
        return view("admin.product-category.store");
    }
    public function list()
    {
        $sort = request("sort") ? request("sort") : "DESC";
        $limit = request("limit") ? request("limit") : defaultLimit();
        $data = ProductCategory::orderBy("id", $sort);
        if ($limit) {
            $data = $data->paginate($limit);
        } else {
            $data = $data->get();
        }
        return view("admin.product-category.list", compact("data"));
    }
    public function edit($id)
    {
        $data = ProductCategory::with(['images'])->where("id", $id)->first();
        return view("admin.product-category.store", compact("data"));
    }
    public function view($id)
    {
        $data = ProductCategory::where("id", $id)->first();
        return view("admin.product-category.view", compact("data"));
    }

    public function store(ProductCategoryRequest $request)
    {
        DB::beginTransaction();
        try {
            $data = [
                "category_name_en" => $request->category_name_en,
                "category_name_bn" => $request->category_name_bn,
                "status" => $request->status,
                "show_in_home"=>1
            ];
            if ($request->hasFile("category_image")) {
                if ($request->has("id")) {
                    $category_image = ProductCategory::where(
                        "id",
                        $request->id
                    )->value("category_image");
                    if ($category_image) {
                        deleteImage("", $category_image);
                    }
                }
                $category_image = imageUpload(
                    $request->file("category_image"),
                    '/category/'
                );
                $data["category_image"] = $category_image;
            }


            $category = ProductCategory::updateOrCreate(['id'=>$request->id],$data);

            $categoryImages = [];
            if($request->images){
                foreach($request->images as $image){
                    $filePath = imageUpload($image,'/category/');
                    $categoryImages[]=[
                        'category_id'=>$category->id,
                        'image'=>$filePath
                    ];
                }
            }

            if(count($categoryImages) > 0){
                CategoryImages::insert($categoryImages);
            }


            DB::commit();
            toastr()->success('Product Category Has Been Created Successfully');
            return redirect()->back();
        } catch (\Exception $e) {
            return $e;
            DB::rollback();
            Log::error("Productcategory -> store : " . $e->getMessage());
            return serverError();
        }
    }

    public function delete($id)
    {
        ProductCategory::where("id", $id)->update([
            "deleted_at" => Carbon::now(),
        ]);
        return redirect()
            ->back()
            ->with("success", "Data Deleted Successfully");
    }

    public function deleteImage($id){
        CategoryImages::where('id',$id)->delete();
        toastr()->success('Category images deleted successfully');
        return redirect()->back();
    }
}
