<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\ProductBasicRequest;
use App\Models\Brands;
use App\Models\Company;
use App\Models\Images;
use App\Models\Product;
use App\Models\ProductBasicInfo;
use App\Models\ProductCategory;
use App\Models\ProductImages;
use App\Models\ProductSubcategory;
use DB;
use Illuminate\Http\Request;

class ProductBasicController extends Controller
{
    public function create()
    {
        $categories = ProductCategory::whereHas('subcategories')->get();
        $brands = Brands::get();
        $companies = Company::get();
        $data=null;
        return view(
            "admin.product-basic-info.form",
            compact("categories", "brands","data","companies")
        );
    }

    public function list()
    {
        $categories = ProductCategory::whereHas('products')->get();
        $subcategories = ProductSubcategory::whereHas('products')->get();
        $brands = Brands::whereHas('products')->get();
        $companies = Company::whereHas('products')->get();
        $products = ProductBasicInfo::with(['category','subcategory','brand','company'])->filter()->get();
        return view("admin.product-basic-info.list",compact("products","categories","brands","companies","subcategories"));
    }

    public function edit($id)
    {
        $categories = ProductCategory::whereHas('subcategories')->get();
        $brands = Brands::get();
        $companies = Company::get();
        $data=ProductBasicInfo::with(['images','thumbnails'])->where('id',$id)->first();
        return view(
            "admin.product-basic-info.form",
            compact("categories", "brands","data","companies")
        );
    }


    public function store(ProductBasicRequest $request){
        DB::beginTransaction();
        try{
            if(!is_numeric($request->company)){
                $companyId = Company::insertGetId(['name'=>$request->company]);
            }else{
                $companyId = $request->company;
            }

            $data = $request->except(['images','thumbnail','_token','id','company']);
            $data['company_id']=$companyId;

            $basicInfo = ProductBasicInfo::updateOrCreate(['id'=>$request->id],$data);
            Product::where('basic_info_id',$basicInfo->id)->update($data);

            $productImages = [];

            if ($request->hasFile('thumbnail')) {
                foreach ($request->file('thumbnail') as $image) {
                    $filePath = imageUpload($image, '/product/');
                    $productImages[] = [
                        'basic_info_id' => $basicInfo->id,
                        'file_path' => $filePath,
                        'type' => PRODUCT_THUMBNAIL_IMAGE
                    ];
                }
            }

            if ($request->hasFile('images')) {
                foreach ($request->file('images') as $image) {
                    $filePath = imageUpload($image, '/product/');
                    $productImages[] = [
                        'basic_info_id' => $basicInfo->id,
                        'file_path' => $filePath,
                        'type' => PRODUCT_IMAGE
                    ];
                }
            }





            if(count($productImages) > 0){
                Images::insert($productImages);
            }

            DB::commit();
            toastr()->success('Product info saved successfully');
            return redirect()->back();
        }catch(\Exception $e){
            return $e;
        }
    }


    public function deleteImage($id){
        $image = Images::find($id);
        if($image->delete()){
            deleteImage("", $image->file_path);
            ProductImages::where('image_id',$id)->delete();
        }

        toastr()->success('Image deleted successfully');
        return redirect()->back();
    }
    
    public function delete($id){
        ProductBasicInfo::where('id',$id)->delete();
        toastr()->success('Product Info Deleted Successfully');
        return redirect()->back();
    }



}
