<?php
namespace App\Http\Controllers\admin;
use App\Enums\Constant;
use App\Enums\Image;
use App\Http\Requests\OfferRequest;
use App\Models\Offer;
use App\Models\OfferProducts;
use App\Models\Product;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Log;
use DB;

class OfferController extends Controller
{
    public $model;
    public function __construct()
    {
        $this->model = new Offer();
    }
    public function create()
    {
        $products = Product::where('status',ACTIVE)->get();
        return view("admin.offer.store",compact('products'));
    }
    public function list()
    {
        $sort = request("sort") ? request("sort") : "DESC";
        $limit = request("limit") ? request("limit") : defaultLimit();
        $data = Offer::orderBy("id", $sort);
        if ($limit) {
            $data = $data->paginate($limit);
        } else {
            $data = $data->get();
        }
        return view("admin.offer.list", compact("data"));
    }
    public function edit($id)
    {
        $products = Product::where('status',ACTIVE)->get();
        $data = Offer::where("id", $id)->first();
        $offeredProducts = OfferProducts::where('offer_id',$data->id)->pluck('product_id')->toArray();
        return view("admin.offer.store", compact("data","products","offeredProducts"));
    }
    public function view($id)
    {
        $data = Offer::where("id", $id)->first();
        return view("admin.offer.view", compact("data"));
    }

    public function store(OfferRequest $request)
    {
        DB::beginTransaction();
        try {
            $data = [
                "offer_name_en" => $request->offer_name_en,
                "offer_name_bn" => $request->offer_name_bn,
                "amount_type" => $request->amount_type,
                "amount" => $request->amount,
                "start_date"=>$request->start_date,
                "end_date"=>$request->end_date,
            ];

            if ($request->file("image")) {
                if ($request->has("id")) {
                    $image = Offer::where("id",$request->id)->value("image");
                    if ($image) {
                        deleteImage("", $image);
                    }
                }
                $image = imageUpload($request->file("image"),'/offer/');
                $data["image"] = $image;
            }

            $offer = Offer::updateOrCreate(['id'=>$request->id],$data);


            OfferProducts::where('id',$offer->id)->delete();
            $offerProducts = [];
            foreach($request->product_ids as $product_id){
                $offerProducts[]=[
                    'product_id'=>$product_id,
                    'offer_id'=>$offer->id
                ];
            }

            OfferProducts::insert($offerProducts);

            DB::commit();
            return redirect()
                ->back()
                ->with("success", "Offer has been saved successfully");
        } catch (\Exception $e) {
            DB::rollback();
            Log::error("Offers -> store : " . $e->getMessage());
            return serverError();
        }
    }

    public function delete($id)
    {
        Offer::find($id)->delete();
        return redirect()
            ->back()
            ->with("success", "Data Deleted Successfully");
    }
}
