<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\DellerRequest;
use App\Models\Shop;
use App\Models\User;
use Illuminate\Http\Request;
use DB;

class DellerController extends Controller
{
    public function create(){
        $data = null;
        return view('admin.deller.form',compact('data'));
    }

    public function list(){
        $data = User::with(['shop'])->filter()->where('role',DELLER)->get();
        return view('admin.deller.list',compact('data'));
    }

    public function edit(){
        $data = User::filter()->where('role',DELLER)->first();
        return view('admin.deller.form',compact('data'));
    }

    public function store(DellerRequest $request){
        DB::beginTransaction();
        try{

            $dellerInfo=[
                'first_name'=>$request->first_name,
                'last_name'=>$request->last_name,
                'email'=>$request->email,
                'phone'=>$request->phone,
                'status'=>$request->status,
                'role'=>DELLER
            ];

            if($request->password){
                $dellerInfo['password'] = \Hash::make($request->password);
            }


            $dellerShopInfo = [
                'shop_name_en'=>$request->shop_name_en,
                'shop_name_bn'=>$request->shop_name_bn,
                'shop_address'=>$request->shop_address,
                'lat'=>$request->lat,
                'lon'=>$request->lon,
                'status'=>$request->shop_status,
            ];

            if ($request->hasFile("deller_image")) {
                if ($request->has("id")) {
                    $deller_image = User::where(
                        "id",
                        $request->id
                    )->value("image");
                    if ($deller_image) {
                        deleteImage("", $deller_image);
                    }
                }
                $deller_image = imageUpload(
                    $request->file("deller_image"),
                    '/deller/'
                );
                $dellerInfo["image"] = $deller_image;
            }


            if ($request->hasFile("shop_logo")) {
                if ($request->has("id")) {
                    $deller_shop_logo = User::where(
                        "id",
                        $request->id
                    )->value("image");
                    if ($deller_shop_logo) {
                        deleteImage("", $deller_shop_logo);
                    }
                }
                $deller_shop_logo = imageUpload(
                    $request->file("shop_logo"),
                    '/deller/'
                );
                $dellerShopInfo["shop_logo"] = $deller_shop_logo;
            }


            if($request->id > 0){
                User::where('id',$request->id)->update($dellerInfo);
                Shop::where('user_id',$request->id)->update($dellerShopInfo);
            }else{
                $dellerId = User::insertGetId($dellerInfo);
                $dellerShopInfo['user_id']=$dellerId;
                Shop::create($dellerShopInfo);
            }
            DB::commit();
            return redirect()->back()->with('success','Deller information save successfully');
        }catch(\Exception $e){
            return $e;
        }
    }
}
