<?php
namespace App\Http\Controllers\admin;
use App\Http\Requests\DeliveryHubRequest;
use App\Models\DeliveryHub;
use App\Models\Districts;
use App\Models\Division;
use GrahamCampbell\ResultType\Success;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Log;
use DB;
use Hash;
use Carbon;

class DeliveryHubController extends Controller
{
    public $model;
    public function __construct()
    {
        $this->model = new DeliveryHub();
    }
    public function create()
    {
        $data=null;
        $divisions = Division::get(); 
        return view("admin.delivery-hub.store",compact('divisions','data'));
    }

    public function districts($division_id)
    {
        $districts = Districts::where('division_id',$division_id)->get(); 
        return response()->json(['success'=>true,'districts'=>$districts]);
    }

    public function list()
    {
        $sort = request("sort") ? request("sort") : "DESC";
        $limit = request("limit") ? request("limit") : defaultLimit();
        $data = DeliveryHub::orderBy("id", $sort);
        if ($limit) {
            $data = $data->paginate($limit);
        } else {
            $data = $data->get();
        }
        return view("admin.delivery-hub.list", compact("data"));
    }

    public function edit($id)
    {
        $data = DeliveryHub::where("id", $id)->first();
        $divisions = Division::get(); 
        return view("admin.delivery-hub.store", compact("data","divisions"));
    }
    public function view($id)
    {
        $data = DeliveryHub::where("id", $id)->first();
        return view("admin.delivery-hub.view", compact("data"));
    }

    public function store(DeliveryHubRequest $request)
    {
        DB::beginTransaction();
        try {
            $hubInfo=$request->except('_token','profile_photo','logo','trade_license','nid','password');
            if($request->password){
                $hubInfo['password'] = Hash::make($request->password);
            }

            if ($request->file("profile_photo")) {
                if ($request->has("id")) {
                    $profilePhoto = DeliveryHub::where("id",$request->id)->value("profile_photo");
                    if ($profilePhoto) {
                        deleteImage("", $profilePhoto);
                    }
                }
                $profilePhoto = imageUpload($request->file("profile_photo"),'/delivery-hub/');
                $hubInfo["profile_photo"] = $profilePhoto;
            }

            if ($request->file("trade_license")) {
                if ($request->has("id")) {
                    $tradeLicense = DeliveryHub::where("id",$request->id)->value("trade_license");
                    if ($tradeLicense) {
                        deleteImage("", $tradeLicense);
                    }
                }
                $tradeLicense = imageUpload($request->file("trade_license"),'/delivery-hub/');
                $hubInfo["trade_license"] = $tradeLicense;
            }

            if ($request->file("nid")) {
                if ($request->has("id")) {
                    $nid = DeliveryHub::where("id",$request->id)->value("nid");
                    if ($nid) {
                        deleteImage("", $nid);
                    }
                }
                $nid = imageUpload($request->file("nid"),'/delivery-hub/');
                $hubInfo["nid"] = $nid;
            }

            if ($request->file("logo")) {
                if ($request->has("id")) {
                    $logo = DeliveryHub::where("id",$request->id)->value("logo");
                    if ($logo) {
                        deleteImage("", $logo);
                    }
                }
                $logo = imageUpload($request->file("logo"),'/delivery-hub/');
                $hubInfo["logo"] = $logo;
            }

            DB::commit();
            DeliveryHub::updateOrCreate(['id'=>$request->id],$hubInfo);
            toastr()->success("Delivery hub information has been saved successfully");
            return redirect()->back();
        } catch (\Exception $e) {
            return $e;
            DB::rollback();
            Log::error("Deliveryhub -> store : " . $e->getMessage());
            return serverError();
        }
    }

    public function delete($id)
    {
        DeliveryHub::where("id", $id)->update(["deleted_at" => Carbon::now()]);
        return redirect()
            ->back()
            ->with("success", "Data Deleted Successfully");
    }
}
