<?php
namespace App\Http\Controllers\admin;
use App\Http\Requests\ColorsRequest;
use App\Models\Colors;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Log;
use DB;

class ColorsController extends Controller
{
    public $model;
    public function __construct()
    {
        $this->model = new Colors();
    }
    public function create()
    {
        $listData = $this->list();
        return view("admin.colors.store", compact("listData"));
    }
    public function list()
    {
        $sort = request("sort") ? request("sort") : "DESC";
        $limit = request("limit") ? request("limit") : defaultLimit();
        $data = Colors::filter()->orderBy("id", $sort);
        if ($limit) {
            $data = $data->paginate($limit);
        } else {
            $data = $data->get();
        }
        return $data;
    }
    public function edit($id)
    {
        $data = Colors::where("id", $id)->first();
        $listData = $this->list();
        return view("admin.colors.store", compact("data", "listData"));
    }
    public function view($id)
    {
        $data = Colors::where("id", $id)->first();
        return view("admin.colors.view", compact("data"));
    }

    public function store(ColorsRequest $request)
    {
        DB::beginTransaction();
        try {
            $data = [
                "color_code" => $request->color_code,
                "color_name" => $request->color_name,
            ];
            if ($request->has("id")) {
                Colors::where("id", $request->id)->update($data);
                $text = "updated";
                DB::commit();
                return redirect()->route('color.create');

            } else {
                Colors::insert($data);
                $text = "created";
            }
            DB::commit();
            return redirect()
                ->back()
                ->with("success", "colors has been " . $text . " successfully");
        } catch (\Exception $e) {
            DB::rollback();
            Log::error("Colors -> store : " . $e->getMessage());
            return serverError();
        }
    }

    public function delete($id)
    {
        Colors::find($id)->delete();
        return redirect()
            ->back()
            ->with("success", "Data Deleted Successfully");
    }
}
