<?php

namespace App\Http\Controllers\Seller;

use App\Http\Controllers\Controller;
use App\Http\Requests\Seller\ShopRequest;
use App\Models\Shop;
use Illuminate\Contracts\View\View;
use Illuminate\Http\Request;

class ShopController extends Controller
{
    public function edit() : View
    {
        $shop = Shop::where('user_id',auth('seller')->id())->first();
        if(!$shop)
            abort(404,'No shop found !');
        return view('seller.shop.edit',compact('shop'));
    }

    public function update(ShopRequest $shopRequest){
        $data = [
            'shop_name_en'=>$shopRequest->shop_name_en,
            'shop_name_bn'=>$shopRequest->shop_name_bn,
            'shop_address'=>$shopRequest->shop_address,
            'phone'=>$shopRequest->phone,
            'lat'=>$shopRequest->lat,
            'lon'=>$shopRequest->lon,
        ];

        $shop = Shop::where("user_id", auth('seller')->id())->first();

        if ($shopRequest->hasFile("image")) {
            if ($shop) {
                deleteImage("", $shop->shop_logo);
            }
            $shop_logo = imageUpload($shopRequest->file("image"),'/shop/');
            $data["shop_logo"] = $shop_logo;
        }

        $shop->update($data);
        toastr()->success('Action submitted properly');
        return redirect()->back();
    }
}
