<?php

namespace App\Http\Controllers\Seller;

use App\Http\Controllers\Controller;
use App\Http\Requests\Seller\LoginRequest;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class AuthController extends Controller
{
    public function loginForm(){
        return view('seller.auth.login');
    }

    public function login(LoginRequest $request){
        $auth = Auth::guard('seller')->attempt(['email'=>$request->email,'password'=>$request->password,'role'=>SELLER,'status'=>ACTIVE]);
        if($auth){
            toastr()->success('Welcome to the seller panel');
            return redirect()->route('seller.dashboard.index');
        }else{
            toastr()->error('Sorry ! invalid email or password');
            return redirect()->back();
        }
    }


    public function logout(){
        auth('seller')->logout();
        return redirect()->route('seller.auth.login.form');
    }
}
