<?php

namespace App\Http\Controllers\Product;

// use Illuminate\Support\Str;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\OrderRequest;
use App\Models\Banner;
use App\Models\CashWalletHistory;
use App\Models\Coupon;
use App\Models\Offer;
use App\Models\Order;
use App\Models\OrderItems;
use App\Models\OrderStatusHistory;
use App\Models\Product;
use App\Models\ProductCategory;
use App\Models\ProductImages;
use App\Models\ProductSubcategory;
use App\Models\ReturnedItem;
use App\Models\Seller;
use App\Models\SellerShop;
use App\Models\Shop;
use App\Models\Subcategory;
use App\Models\User;
use App\Models\Withdrawal;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ProductsController extends Controller{
    public function getHomePageData () {
        try {
            $banners = Banner::selectRaw('banner_image,type,link')->where('status', ACTIVE)->get();
            $featuredProducts = Product::selectRaw('id,thumbnail,product_name_'.getLang().' as product_name,customer_discount,sale_price,original_price')->where('is_featured', ACTIVE)->where('show_in_home', SHOW_IN_HOME)->take(6)->get();
            $latestProducts = Product::selectRaw('id,thumbnail,product_name_'.getLang().' as product_name,customer_discount,sale_price,original_price')->where('show_in_home', SHOW_IN_HOME)->orderBy('created_at', 'desc')->take(10)->get();
            $categorys = ProductCategory::selectRaw('id,category_image,category_name_'.getLang().' as category_name')->where('status', ACTIVE)->where('show_in_home', SHOW_IN_HOME)->take(10)->get();
            $shops = Shop::selectRaw('id,shop_logo,shop_name_'.getLang().' as shop_name')->where('status', ACTIVE)->take(10)->get();
            $bestSellers = Product::selectRaw('id,thumbnail,product_name_'.getLang().' as product_name,customer_discount,sale_price,original_price')->where('status',ACTIVE)->orderBy('total_sold','DESC')->get();
            $today = now();
            $offerBanner = Offer::where('start_date', '<=', $today)
                    ->where('end_date', '>=', $today)
                    ->get();

            return response()->json([
                'message' => "Home page data sent.",
                'banner' => $banners,
                'featuredProducts' => $featuredProducts,
                'latestProducts' => $latestProducts,
                'categories' => $categorys,
                'shops' => $shops,
                'bestSellers'=>$bestSellers,
                // 'categoryWiseProducts' => $categoryWiseProduct,
                'offerBanner' => $offerBanner,
            ], 200); // 200 ok
        } catch (\Exception $e) {
            // Log or handle the exception appropriately
            return response()->json([
                'error' => 'Internal Server Error',
                'message' => 'Internal Server Error',
                'err' => $e,
            ], 500);
        }
    }

    public function getCategories(){
        $categoryies = ProductCategory::selectRaw('id,category_image,category_name_'.getLang().' as category_name')->where('status', ACTIVE)->get();
        return response()->json(['success'=>true,'data'=>$categoryies]);
    }

    public function getShops(){
        $shops = Shop::selectRaw('id,shop_logo,shop_name_'.getLang().' as shop_name')->where('status', ACTIVE)->get();
        return response()->json(['success'=>true,'data'=>$shops]);
    }

    public function getCategoryProducts(){
        $data = ProductCategory::selectRaw('id,category_image,category_name_'.getLang().' as category_name')->with(['products'])->where('show_in_home',1)->take(5)->get();
        return response()->json(['success'=>true,'data'=>$data]);
    }



    public function getProductInGroup () {
        try{
            $data = Product::filterdata()->selectRaw('id,thumbnail,product_name_'.getLang().' as product_name,customer_discount,sale_price,original_price')->paginate(10);
            return response()->json(['data'=>$data->items(),'total_page'=>$data->total(),'current_page'=>$data->currentPage()]);
        }catch(\Exception $e) {
            return response()->json([
                'message' => 'Internal Server Error',
                'error' => 'Internal Server Error',
                // 'err' => $e
            ], 500);
        }
    }

    public function getProductDetails ($id) {
        try{
            // product details
            $data = Product::selectRaw('*product_name_'.getLang().' as product_name')->with(['images','shop','brand','category','subcategory'])->where('id',$id)->first();
            $data->setRelation('images', $data->images->pluck('file_url'));
            $data->sizes = explode(',',$data->sizes);
            $data->colors = explode(',',$data->colors);
            // $productReview = ProductReview::where('id', $productDetails->review_id)->get();
            $relatedProduct = Product::selectRaw('id,thumbnail,product_name_'.getLang().' as product_name,customer_discount,sale_price,original_price')->where('subcategory_id', $data->subcategory_id)->where('id','!=',$id)->take(4)->get();

            return response()->json([
                'message' => "Product realated data sent.",
                'data' => $data,
                // 'productReview' => $productReview,
                'relatedProduct' => $relatedProduct,
            ], 200); // 200 ok
        } catch (\Exception $e) {
            return response()->json([
                'message' => 'Internal Server Error',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    public function getOrderListForUser (Request $request) {
        try{
            $userId = $request->userId;
            $orders = Order::where('user_id', $userId)->get();
            // return $userId;

            return response()->json([
                "message" => "User Orders Sent.",
                "orders" => $orders,
            ], 200);

        }catch (\Exception $e) {
            return response()->json([
                'message' => "Internal Server Error",
                'error' => $e->getMessage()
            ], 500);
        }
    }

    public function getOrderDetails ($id) {
        try{
            $orderDetails = Order::where('id', $id)->get();

            return response()->json([
                "message" => "Order details Sent.",
                "orderDetails" => $orderDetails,
            ], 200);

        }catch (\Exception $e) {
            return response()->json([
                'message' => "Internal Server Error",
                'error' => $e->getMessage()
            ], 500);
        }
    }


    // public function placeOrder (Request $request) {



}
