<?php

namespace App\Http\Controllers\Hub;

use App\Http\Controllers\Controller;
use App\Models\Order;
use Illuminate\Http\Request;

class OrderController extends Controller
{
    public function index(){
        return view('hub.order.index');
    }

    public function orders(){
        $orders = Order::where('hub_id',auth('hub_id'))->where('order_type','mystore')->orderBy('id','desc')->get();
        return view('hub.order.list',compact('orders'));
    }

    public function details(){
        $order = Order::where('order_number',request('order_number'))->first();
        if($order){
            return view('hub.order.details',compact('order'));
        }else{
            toastr()->error('Sorry ! No Order Found With This Order Number');
            // return redirect()->back();
        }
    }
}
