<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\Api\RankResource;
use App\Http\Resources\Api\UserResource;
use App\Models\Contact;
use App\Models\Order;
use App\Models\Rank;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class UserController extends Controller
{
    public function sponsors(){
        $sponsors = User::where('parent_id',auth()->id())
                ->get();
        return response()->json(['success' =>true, 'sponsors' =>UserResource::collection($sponsors)]);
    }

    public function team($noResponse=false){
        $userId = Auth::user()->id;
        $teamAUserId = [];
        $teamBUserId = [];
        // user has 2 team Team A & Team b
        // at first get the starting point of that 2 team
        $userTeam =  User::where('team_parent_id',$userId)->orderBy('id','ASC')->get();
        if($userTeam->isEmpty()){
            return response()->json([
                'data'=>[]
            ]);
        }

        $teamA = $userTeam->first();
        $teamB = $userTeam->skip(1)->last();
        if($teamA){
            $teamAUserId = [$teamA->id];
        }
        if($teamB){
            $teamBUserId = [$teamB->id];
        }

        $referralChain = collect();
        $referralChain->push([
            'layer'=>1,
            'total_team_A_users'=>count($teamAUserId),
            'total_team_B_users'=>count($teamBUserId),
            'team_A_users'=>[new UserResource($teamA)],
            'team_B_users'=>[new UserResource($teamB)],
        ]);


        $totalTeamAUsers = count($teamAUserId);
        $totalTeamBUsers = count($teamBUserId);


        for ($i = 2; $i < maxComissionLevel(); $i++) {
            $teamAUser = User::whereIn('team_parent_id',$teamAUserId)->where('role',CUSTOMER)->get();
            $teamBUser = User::whereIn('team_parent_id',$teamBUserId)->where('role',CUSTOMER)->get();
            if ($teamAUser->isEmpty() && $teamBUser->isEmpty()) {
                break; // Break the loop if no users found at this level
            }

            $teamAUserId = $teamAUser->pluck('id')->toArray();
            $teamBUserId = $teamBUser->pluck('id')->toArray();

            $totalTeamAUsers += $teamAUser->count();
            $totalTeamBUsers += $teamAUser->count();

            $layer = [
                'layer'=>$i,
                'total_team_A_users'=>$teamAUser->count(),
                'total_team_B_users'=>$teamAUser->count(),
                'team_A_users'=>UserResource::collection($teamAUser),
                'team_B_users'=>UserResource::collection($teamBUser),
            ];

            $referralChain->push($layer);


        }

        if($noResponse == true){
            return $referralChain;
        }

        return response()->json([
            'teams'=>$referralChain,
            'total_users'=>[
                'team_A'=>$totalTeamAUsers,
                'team_B'=>$totalTeamBUsers,
            ]
        ]);
    }

    public function leadership(){
        $userId = [Auth::user()->id];
        $leaderShips = collect();
        $totalUser = 0;

        for ($i = 1; $i < maxComissionLevel(); $i++) {
            $users = User::whereIn('parent_id',$userId)->where('role',CUSTOMER)->get();
            if ($users->isEmpty()) {
                break; // Break the loop if no users found at this level
            }

            $layer = [
                'layer'=>$i,
                'total_users'=>$users->count(),
                'users'=>UserResource::collection($users),
            ];

            $userId = $users->pluck('id')->toArray();

            $leaderShips->push($layer);
            $totalUser += $users->count();
        }

        return response()->json([
            'data'=>$leaderShips,
            'total_users'=>$totalUser,
        ]);
    }

    public function ranks(){
        $teams = $this->team(true);
        $teamAUsers = collect([]);
        $teamBUsers = collect([]);

        foreach ($teams as $team) {
            $teamAUsers = $teamAUsers->merge($team['team_A_users']);
            $teamBUsers = $teamBUsers->merge($team['team_B_users']);
        }

        $teamAordersTotal =  Order::where('user_id',$teamAUsers->pluck('user_id')->toArray())->sum('order_total');
        $teamBordersTotal =  Order::where('user_id',$teamBUsers->pluck('user_id')->toArray())->sum('order_total');

        $ranks = Rank::get();
        $userRank = $ranks->where('id',auth()->user()->rank_id)->first();

        $ranks->each(function($rank)use($teamAordersTotal,$teamBordersTotal,$teamAUsers,$teamBUsers){
            if($rank->type == 1){
                $user_team_A_amount =  $teamAordersTotal;
                $user_team_B_amount =  $teamBordersTotal;
            }else{
                $user_team_A_amount =  $teamAUsers->where('rank_id',operator: $rank->id-1)->count();
                $user_team_B_amount =  $teamBUsers->where('rank_id',operator: $rank->id-1)->count();
            }

            $rank->user_team_A_amount = $user_team_A_amount;
            $rank->user_team_B_amount = $user_team_B_amount;

            if($user_team_A_amount >= $rank->team_A_amount && $user_team_B_amount >= $rank->team_B_amount){
                $rank->user_status = 1;
            }else{
                $rank->user_status = 0;
            }
            $rank->type = getRankTypes()[$rank->type];
        });

        return response()->json(['success' =>true, 'ranks' => $ranks,'user_rank'=>$userRank]);
    }

    public function contact(){
        $contacts = Contact::get();
        return response()->json(['success' =>true, 'contacts' => $contacts]);
    }


    public function earnMoney(){
        return response()->json([
            'total_earning'=>0,
            'total_withdrawal'=>0,
            'withdraw_available'=>0,
            'reffer_earning'=>0,
            'team_earning'=>0,
            're_purchase_earning'=>0,
            'reffer_royalti_earning'=>0,
            'update_earning'=>0,
            'hub_earning'=>0,
            'stockist_earning'=>0,
            'dealer_earning'=>0,
            'agent_earning'=>0,
            'dropshipper_earning'=>0,
            'ecommerce_earning'=>0,
        ]);
    }


}
