<?php

namespace App\Http\Controllers\Agent;

use App\Http\Controllers\Controller;
use App\Http\Requests\Agent\LoginRequest;
use App\Http\Requests\Agent\RegistrationRequest;
use App\Http\Requests\Agent\SendOtpRequest;
use App\Http\Requests\Agent\VerifyOtpRequest;
use App\Models\Notification;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;

class AuthController extends Controller
{
    public function login(LoginRequest $loginRequest){
        try{
            $user = User::where('phone', $loginRequest->phone)->whereNotNull('phone_verified_at')->whereNull('deleted_at')->first();
            if($user){
                $otpLastGeneratedAt = Carbon::parse($user->otp_last_generated_at);
                $currentDateTime = Carbon::now();
                $timeDifference = $currentDateTime->diffInMinutes($otpLastGeneratedAt);
                $data = [];
                if($timeDifference > 5){
                    $otp = str_pad(rand(0, 9999), 4, '0', STR_PAD_LEFT);
                    $data['otp']=$otp;
                    $data['otp_last_generated_at']=Carbon::now();
                    $user->update($data);

                    $message = 'Your Otp Is '.$otp.' From Ezone . Please Visit https://admin.robiulawal.xyz';
                    Notification::sendSms($message,'0'.$loginRequest->phone);
                    return response()->json([
                        'message' => "We sent an otp to your phone",
                    ], 200);
                }else{
                    return response()->json([
                        'message' => "We already sent an otp to your phone",
                    ], 200);
                }

            }else{
                return response()->json(['success'=>false,'message'=>'Sorry ! No Account Found'],400);
            }
        }catch(\Exception $e){
            return response()->json([
                'message' => 'Internal Server Error',
            ], 500);
        }
    }

    public function sendOtp(SendOtpRequest $sendOtpRequest){
        $otp = rand(111111,999999);
        $user = User::where('phone',$sendOtpRequest->phone)->first();

        //if password is avaialble that means account has been created
        if($user?->password)
            return response()->json(['success'=>false,'message'=>'Sorry , an account is already registered by this number'],403);

        //if phone is verified then we will not send verification code to user again
        if($user->phone_verified_at)
            return response()->json(['success'=>true,'message'=>'Phone is already verified','is_phone_verified'=>true],200);

        $data = [
            'otp'=>$otp,
            'phone'=>$sendOtpRequest->phone,
            'otp_last_generated_at'=>Carbon::now(),
            'role'=>AGENT,
            'status'=>DEACTIVE
        ];

        if($user){
            //send otp only after a limited time
            $otpLastGeneratedAt = Carbon::parse($user->otp_last_generated_at);
            $currentDateTime = Carbon::now();
            $timeDifference = $currentDateTime->diffInMinutes($otpLastGeneratedAt);

            if($timeDifference > OTP_RESEND_INTERVAL)
                return response()->json(['success'=>false,'message'=>'We already sent you an otp to your phone'],403);

            $user->update($data);
        }else{
            User::create($data);
        }

        return response()->json(['success'=>true,'message'=>'Congratulations , Your phone has been verified successfully']);

    }

    public function verifyOtp(VerifyOtpRequest $verifyOtpRequest){
        $user = User::where('phone',$verifyOtpRequest->phone)->first();
        if($user){
            if($user->otp === $verifyOtpRequest->otp){
                $user->update(['phone_verified_at'=>Carbon::now()]);
                return response()->json(['success'=>true,'message'=>"Your phone has been verified successfully"],200);
            }else{
                return response()->json(['success'=>false,'message'=>"Sorry , You entered wrong OTP"],403);
            }
        }else{
            return response()->json(['success'=>false,'message'=>"Sorry , We didn't found your account"],403);
        }
    }

    public function registration(RegistrationRequest $registrationRequest){
        $user = User::where('phone',$registrationRequest->phone)->first();
        if($user){
            $data = [
                'first_name'=>$registrationRequest->first_name,
                'last_name'=>$registrationRequest->last_name,
                'address'=>$registrationRequest->address,
                'password'=>$registrationRequest->pin,
                'phone_verified_at'=>Carbon::now(),
                'role'=>AGENT,
                'status'=>ACTIVE
            ];

            $user->update($data);
        }else{
            return response()->json(['success'=>false,'message'=>"Sorry , We didn't found your account"],403);
        }

        return response()->json(['success'=>true,'message'=>'Congratulations , Your Account has been registered successfully'],200);
    }
}
